import AuthenticatedLayout from '@/Layouts/AuthenticatedLayout';
import { Head, Link, useForm } from '@inertiajs/react';

export default function Create({ owners }) {
    const { data, setData, post, processing, errors } = useForm({
        owner_id: '',
        shop_number: '',
        description: '',
        location: '',
        area_sqft: '',
        default_rent: '',
    });

    const handleSubmit = (e) => {
        e.preventDefault();
        post(route('shops.store'));
    };

    return (
        <AuthenticatedLayout header={<h2 className="text-xl font-semibold leading-tight text-gray-800">Add Shop</h2>}>
            <Head title="Add Shop" />

            <div className="py-12">
                <div className="mx-auto max-w-2xl sm:px-6 lg:px-8">
                    <div className="overflow-hidden bg-white shadow-sm sm:rounded-lg">
                        <div className="p-6 text-gray-900">
                            <form onSubmit={handleSubmit} className="space-y-6">
                                {/* Owner */}
                                <div>
                                    <label className="block text-sm font-medium text-gray-700">Owner <span className="text-red-500">*</span></label>
                                    <select
                                        value={data.owner_id}
                                        onChange={(e) => setData('owner_id', e.target.value)}
                                        className="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500"
                                    >
                                        <option value="">Select Owner</option>
                                        {owners.map((owner) => (
                                            <option key={owner.id} value={owner.id}>{owner.name}</option>
                                        ))}
                                    </select>
                                    {errors.owner_id && <p className="mt-1 text-sm text-red-600">{errors.owner_id}</p>}
                                </div>

                                {/* Shop Number */}
                                <div>
                                    <label className="block text-sm font-medium text-gray-700">Shop Number <span className="text-red-500">*</span></label>
                                    <input
                                        type="text"
                                        value={data.shop_number}
                                        onChange={(e) => setData('shop_number', e.target.value)}
                                        className="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500"
                                    />
                                    {errors.shop_number && <p className="mt-1 text-sm text-red-600">{errors.shop_number}</p>}
                                </div>

                                {/* Description */}
                                <div>
                                    <label className="block text-sm font-medium text-gray-700">Description</label>
                                    <textarea
                                        value={data.description}
                                        onChange={(e) => setData('description', e.target.value)}
                                        rows={3}
                                        className="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500"
                                    />
                                    {errors.description && <p className="mt-1 text-sm text-red-600">{errors.description}</p>}
                                </div>

                                {/* Location */}
                                <div>
                                    <label className="block text-sm font-medium text-gray-700">Location</label>
                                    <input
                                        type="text"
                                        value={data.location}
                                        onChange={(e) => setData('location', e.target.value)}
                                        className="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500"
                                    />
                                    {errors.location && <p className="mt-1 text-sm text-red-600">{errors.location}</p>}
                                </div>

                                {/* Area */}
                                <div>
                                    <label className="block text-sm font-medium text-gray-700">Area (sq ft)</label>
                                    <input
                                        type="number"
                                        value={data.area_sqft}
                                        onChange={(e) => setData('area_sqft', e.target.value)}
                                        className="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500"
                                    />
                                    {errors.area_sqft && <p className="mt-1 text-sm text-red-600">{errors.area_sqft}</p>}
                                </div>

                                {/* Default Rent */}
                                <div>
                                    <label className="block text-sm font-medium text-gray-700">Default Rent (PKR) <span className="text-red-500">*</span></label>
                                    <input
                                        type="number"
                                        value={data.default_rent}
                                        onChange={(e) => setData('default_rent', e.target.value)}
                                        className="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500"
                                    />
                                    {errors.default_rent && <p className="mt-1 text-sm text-red-600">{errors.default_rent}</p>}
                                </div>

                                {/* Actions */}
                                <div className="flex items-center justify-end gap-4">
                                    <Link href={route('shops.index')} className="text-sm text-gray-600 hover:text-gray-900">Cancel</Link>
                                    <button
                                        type="submit"
                                        disabled={processing}
                                        className="inline-flex items-center rounded-md bg-blue-600 px-4 py-2 text-sm font-medium text-white hover:bg-blue-700 disabled:opacity-50"
                                    >
                                        Create Shop
                                    </button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </AuthenticatedLayout>
    );
}
