import AuthenticatedLayout from '@/Layouts/AuthenticatedLayout';
import { Head, Link, useForm, router } from '@inertiajs/react';
import { formatCurrency, formatDate, formatMonth } from '@/utils';

export default function TenantDues({ leases }) {
    const duesOnly = leases.filter((item) => parseFloat(item.total_dues || 0) > 0);

    return (
        <AuthenticatedLayout header={<h2 className="text-xl font-semibold leading-tight text-gray-800">Tenant Dues Report</h2>}>
            <Head title="Tenant Dues Report" />

            <div className="py-12">
                <div className="mx-auto max-w-7xl sm:px-6 lg:px-8 space-y-6">
                    {/* Header */}
                    <div className="bg-white shadow-sm sm:rounded-lg p-6">
                        <div className="flex items-center justify-between">
                            <h3 className="text-lg font-medium">Tenants with Outstanding Dues</h3>
                            <Link href={route('reports.index')} className="inline-flex items-center rounded-md bg-gray-200 px-4 py-2 text-sm font-medium text-gray-700 hover:bg-gray-300">Back to Reports</Link>
                        </div>
                    </div>

                    {/* Table */}
                    <div className="bg-white shadow-sm sm:rounded-lg overflow-hidden">
                        <div className="p-6 text-gray-900">
                            <div className="overflow-x-auto">
                                <table className="min-w-full divide-y divide-gray-200">
                                    <thead className="bg-gray-50">
                                        <tr>
                                            <th className="px-4 py-3 text-left text-xs font-medium uppercase tracking-wider text-gray-500">Tenant</th>
                                            <th className="px-4 py-3 text-left text-xs font-medium uppercase tracking-wider text-gray-500">Shop#</th>
                                            <th className="px-4 py-3 text-right text-xs font-medium uppercase tracking-wider text-gray-500">Rent Dues</th>
                                            <th className="px-4 py-3 text-right text-xs font-medium uppercase tracking-wider text-gray-500">Security Deposit Due</th>
                                            <th className="px-4 py-3 text-right text-xs font-medium uppercase tracking-wider text-gray-500">Total Dues</th>
                                        </tr>
                                    </thead>
                                    <tbody className="divide-y divide-gray-200 bg-white">
                                        {duesOnly.map((item, idx) => (
                                            <tr key={idx} className="hover:bg-gray-50">
                                                <td className="whitespace-nowrap px-4 py-4 text-sm font-medium text-gray-900">{item.lease?.tenant?.name || '—'}</td>
                                                <td className="whitespace-nowrap px-4 py-4 text-sm text-gray-900">Shop {item.lease?.shop?.shop_number || '—'}</td>
                                                <td className="whitespace-nowrap px-4 py-4 text-sm text-right text-red-700">{formatCurrency(item.rent_dues)}</td>
                                                <td className="whitespace-nowrap px-4 py-4 text-sm text-right text-red-700">{formatCurrency(item.security_deposit_due)}</td>
                                                <td className="whitespace-nowrap px-4 py-4 text-sm text-right font-bold text-red-800">{formatCurrency(item.total_dues)}</td>
                                            </tr>
                                        ))}
                                        {duesOnly.length === 0 && (
                                            <tr>
                                                <td colSpan="5" className="px-4 py-4 text-center text-sm text-gray-500">No outstanding dues found. All tenants are clear!</td>
                                            </tr>
                                        )}
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </AuthenticatedLayout>
    );
}
