import AuthenticatedLayout from '@/Layouts/AuthenticatedLayout';
import { Head, Link, useForm, router } from '@inertiajs/react';
import { formatCurrency, formatDate, formatMonth } from '@/utils';

export default function OwnerWise({ owners }) {
    return (
        <AuthenticatedLayout header={<h2 className="text-xl font-semibold leading-tight text-gray-800">Owner Wise Report</h2>}>
            <Head title="Owner Wise Report" />

            <div className="py-12">
                <div className="mx-auto max-w-7xl sm:px-6 lg:px-8 space-y-6">
                    {/* Header */}
                    <div className="bg-white shadow-sm sm:rounded-lg p-6">
                        <div className="flex items-center justify-between">
                            <h3 className="text-lg font-medium">Owner Wise Summary</h3>
                            <Link href={route('reports.index')} className="inline-flex items-center rounded-md bg-gray-200 px-4 py-2 text-sm font-medium text-gray-700 hover:bg-gray-300">Back to Reports</Link>
                        </div>
                    </div>

                    {/* Table */}
                    <div className="bg-white shadow-sm sm:rounded-lg overflow-hidden">
                        <div className="p-6 text-gray-900">
                            <div className="overflow-x-auto">
                                <table className="min-w-full divide-y divide-gray-200">
                                    <thead className="bg-gray-50">
                                        <tr>
                                            <th className="px-4 py-3 text-left text-xs font-medium uppercase tracking-wider text-gray-500">Owner</th>
                                            <th className="px-4 py-3 text-center text-xs font-medium uppercase tracking-wider text-gray-500">Shops</th>
                                            <th className="px-4 py-3 text-right text-xs font-medium uppercase tracking-wider text-gray-500">Total Collected</th>
                                            <th className="px-4 py-3 text-right text-xs font-medium uppercase tracking-wider text-gray-500">Paid to Owner</th>
                                            <th className="px-4 py-3 text-right text-xs font-medium uppercase tracking-wider text-gray-500">Pending to Owner</th>
                                        </tr>
                                    </thead>
                                    <tbody className="divide-y divide-gray-200 bg-white">
                                        {owners.map((item, idx) => {
                                            const pending = parseFloat(item.pending_to_owner || 0);
                                            return (
                                                <tr key={idx} className="hover:bg-gray-50">
                                                    <td className="whitespace-nowrap px-4 py-4 text-sm font-medium text-gray-900">{item.owner?.name || '—'}</td>
                                                    <td className="whitespace-nowrap px-4 py-4 text-sm text-center text-gray-500">{item.total_shops}</td>
                                                    <td className="whitespace-nowrap px-4 py-4 text-sm text-right text-gray-900">{formatCurrency(item.total_rent_collected)}</td>
                                                    <td className="whitespace-nowrap px-4 py-4 text-sm text-right text-green-700">{formatCurrency(item.total_paid_to_owner)}</td>
                                                    <td className={`whitespace-nowrap px-4 py-4 text-sm text-right font-medium ${pending > 0 ? 'text-red-700' : 'text-gray-900'}`}>
                                                        {formatCurrency(pending)}
                                                    </td>
                                                </tr>
                                            );
                                        })}
                                        {owners.length === 0 && (
                                            <tr>
                                                <td colSpan="5" className="px-4 py-4 text-center text-sm text-gray-500">No data found.</td>
                                            </tr>
                                        )}
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </AuthenticatedLayout>
    );
}
