import AuthenticatedLayout from '@/Layouts/AuthenticatedLayout';
import { Head, Link } from '@inertiajs/react';
import { formatCurrency, formatDate } from '@/utils';

export default function Show({ payment }) {
    const invoice = payment.invoice;
    const lease = invoice?.lease;
    const tenant = lease?.tenant;
    const shop = lease?.shop;

    return (
        <AuthenticatedLayout header={<h2 className="text-xl font-semibold leading-tight text-gray-800">Payment Details</h2>}>
            <Head title="Payment Details" />

            <div className="py-12">
                <div className="mx-auto max-w-3xl sm:px-6 lg:px-8 space-y-6">
                    {/* Payment Details Card */}
                    <div className="overflow-hidden bg-white shadow-sm sm:rounded-lg">
                        <div className="p-6 text-gray-900">
                            <div className="flex items-center justify-between mb-6">
                                <h3 className="text-lg font-medium">Payment Details</h3>
                                <Link href={route('payments.index')} className="inline-flex items-center rounded-md bg-gray-200 px-4 py-2 text-sm font-medium text-gray-700 hover:bg-gray-300">Back</Link>
                            </div>

                            <dl className="grid grid-cols-1 gap-x-4 gap-y-4 sm:grid-cols-2">
                                <div>
                                    <dt className="text-sm font-medium text-gray-500">Amount Paid</dt>
                                    <dd className="mt-1 text-lg font-semibold text-green-700">{formatCurrency(payment.amount_paid)}</dd>
                                </div>
                                <div>
                                    <dt className="text-sm font-medium text-gray-500">Payment Date</dt>
                                    <dd className="mt-1 text-sm text-gray-900">{formatDate(payment.payment_date)}</dd>
                                </div>
                                <div>
                                    <dt className="text-sm font-medium text-gray-500">Payment Method</dt>
                                    <dd className="mt-1 text-sm text-gray-900 capitalize">{payment.payment_method?.replace('_', ' ')}</dd>
                                </div>
                                <div>
                                    <dt className="text-sm font-medium text-gray-500">Received By</dt>
                                    <dd className="mt-1 text-sm text-gray-900">{payment.received_by || '—'}</dd>
                                </div>
                                <div className="sm:col-span-2">
                                    <dt className="text-sm font-medium text-gray-500">Remarks</dt>
                                    <dd className="mt-1 text-sm text-gray-900">{payment.remarks || '—'}</dd>
                                </div>
                            </dl>
                        </div>
                    </div>

                    {/* Proof File */}
                    {payment.proof_file && (
                        <div className="overflow-hidden bg-white shadow-sm sm:rounded-lg">
                            <div className="p-6 text-gray-900">
                                <h4 className="text-sm font-semibold text-gray-700 mb-4">Payment Proof</h4>
                                {payment.proof_file.match(/\.(jpg|jpeg|png|gif|webp)$/i) ? (
                                    <div>
                                        <img
                                            src={`/storage/${payment.proof_file}`}
                                            alt="Payment proof"
                                            className="max-w-full rounded-lg border border-gray-200"
                                            style={{ maxHeight: '400px' }}
                                        />
                                        <a
                                            href={`/storage/${payment.proof_file}`}
                                            target="_blank"
                                            rel="noopener noreferrer"
                                            className="mt-2 inline-flex items-center text-sm text-blue-600 hover:text-blue-900"
                                        >
                                            Open Full Size →
                                        </a>
                                    </div>
                                ) : (
                                    <a
                                        href={`/storage/${payment.proof_file}`}
                                        target="_blank"
                                        rel="noopener noreferrer"
                                        className="inline-flex items-center rounded-md bg-blue-50 px-4 py-2 text-sm font-medium text-blue-700 hover:bg-blue-100"
                                    >
                                        📄 View Proof File
                                    </a>
                                )}
                            </div>
                        </div>
                    )}

                    {/* Invoice Reference */}
                    {invoice && (
                        <div className="overflow-hidden bg-white shadow-sm sm:rounded-lg">
                            <div className="p-6 text-gray-900">
                                <h4 className="text-sm font-semibold text-gray-700 mb-4">Invoice Reference</h4>
                                <dl className="grid grid-cols-1 gap-x-4 gap-y-4 sm:grid-cols-2">
                                    <div>
                                        <dt className="text-sm font-medium text-gray-500">Invoice #</dt>
                                        <dd className="mt-1 text-sm text-gray-900">
                                            <Link href={route('invoices.show', invoice.id)} className="text-blue-600 hover:text-blue-900">
                                                {invoice.invoice_number}
                                            </Link>
                                        </dd>
                                    </div>
                                    <div>
                                        <dt className="text-sm font-medium text-gray-500">Total Amount</dt>
                                        <dd className="mt-1 text-sm text-gray-900">{formatCurrency(invoice.total_amount)}</dd>
                                    </div>
                                    <div>
                                        <dt className="text-sm font-medium text-gray-500">Tenant</dt>
                                        <dd className="mt-1 text-sm text-gray-900">{tenant?.name || '—'}</dd>
                                    </div>
                                    <div>
                                        <dt className="text-sm font-medium text-gray-500">Shop #</dt>
                                        <dd className="mt-1 text-sm text-gray-900">{shop?.shop_number || '—'}</dd>
                                    </div>
                                </dl>
                            </div>
                        </div>
                    )}
                </div>
            </div>
        </AuthenticatedLayout>
    );
}
