import AuthenticatedLayout from '@/Layouts/AuthenticatedLayout';
import { Head, Link, useForm, router } from '@inertiajs/react';
import { formatCurrency, formatDate, formatMonth } from '@/utils';

export default function Show({ payment }) {
    const owner = payment.owner;

    return (
        <AuthenticatedLayout header={<h2 className="text-xl font-semibold leading-tight text-gray-800">Owner Payment Details</h2>}>
            <Head title="Owner Payment Details" />

            <div className="py-12">
                <div className="mx-auto max-w-3xl sm:px-6 lg:px-8 space-y-6">
                    {/* Voucher Details */}
                    <div className="overflow-hidden bg-white shadow-sm sm:rounded-lg">
                        <div className="p-6 text-gray-900">
                            <div className="flex items-center justify-between mb-6">
                                <h3 className="text-lg font-medium">Voucher Details</h3>
                                <div className="flex gap-2">
                                    <Link
                                        href={route('owner-payments.print', payment.id)}
                                        className="inline-flex items-center rounded-md bg-green-600 px-4 py-2 text-sm font-medium text-white hover:bg-green-700"
                                    >
                                        Print Voucher
                                    </Link>
                                    <Link href={route('owner-payments.index')} className="inline-flex items-center rounded-md bg-gray-200 px-4 py-2 text-sm font-medium text-gray-700 hover:bg-gray-300">Back</Link>
                                </div>
                            </div>

                            <dl className="grid grid-cols-1 gap-x-4 gap-y-4 sm:grid-cols-2">
                                <div>
                                    <dt className="text-sm font-medium text-gray-500">Voucher #</dt>
                                    <dd className="mt-1 text-sm font-semibold text-gray-900">{payment.voucher_number}</dd>
                                </div>
                                <div>
                                    <dt className="text-sm font-medium text-gray-500">Owner</dt>
                                    <dd className="mt-1 text-sm text-gray-900">{owner?.name || '—'}</dd>
                                </div>
                                <div>
                                    <dt className="text-sm font-medium text-gray-500">Payment Date</dt>
                                    <dd className="mt-1 text-sm text-gray-900">{formatDate(payment.payment_date)}</dd>
                                </div>
                                <div>
                                    <dt className="text-sm font-medium text-gray-500">Payment Method</dt>
                                    <dd className="mt-1 text-sm text-gray-900 capitalize">{payment.payment_method?.replace('_', ' ')}</dd>
                                </div>
                                <div>
                                    <dt className="text-sm font-medium text-gray-500">Total Amount</dt>
                                    <dd className="mt-1 text-lg font-bold text-green-700">{formatCurrency(payment.total_amount)}</dd>
                                </div>
                                <div>
                                    <dt className="text-sm font-medium text-gray-500">Signature Status</dt>
                                    <dd className="mt-1 text-sm">
                                        {payment.owner_signature_taken ? (
                                            <span className="inline-flex items-center rounded-full bg-green-100 px-2.5 py-0.5 text-xs font-medium text-green-800">Signed ✓</span>
                                        ) : (
                                            <span className="inline-flex items-center rounded-full bg-yellow-100 px-2.5 py-0.5 text-xs font-medium text-yellow-800">Not Signed</span>
                                        )}
                                    </dd>
                                </div>
                                {payment.remarks && (
                                    <div className="sm:col-span-2">
                                        <dt className="text-sm font-medium text-gray-500">Remarks</dt>
                                        <dd className="mt-1 text-sm text-gray-900">{payment.remarks}</dd>
                                    </div>
                                )}
                            </dl>
                        </div>
                    </div>

                    {/* Items Table */}
                    <div className="overflow-hidden bg-white shadow-sm sm:rounded-lg">
                        <div className="p-6 text-gray-900">
                            <h4 className="text-sm font-semibold text-gray-700 mb-4">Payment Items</h4>
                            <div className="overflow-x-auto">
                                <table className="min-w-full divide-y divide-gray-200">
                                    <thead className="bg-gray-50">
                                        <tr>
                                            <th className="px-4 py-3 text-left text-xs font-medium uppercase tracking-wider text-gray-500">#</th>
                                            <th className="px-4 py-3 text-left text-xs font-medium uppercase tracking-wider text-gray-500">Shop#</th>
                                            <th className="px-4 py-3 text-left text-xs font-medium uppercase tracking-wider text-gray-500">Month</th>
                                            <th className="px-4 py-3 text-right text-xs font-medium uppercase tracking-wider text-gray-500">Amount</th>
                                        </tr>
                                    </thead>
                                    <tbody className="divide-y divide-gray-200 bg-white">
                                        {payment.items?.map((item, idx) => (
                                            <tr key={item.id} className="hover:bg-gray-50">
                                                <td className="whitespace-nowrap px-4 py-3 text-sm text-gray-500">{idx + 1}</td>
                                                <td className="whitespace-nowrap px-4 py-3 text-sm text-gray-900">Shop {item.shop?.shop_number || '—'}</td>
                                                <td className="whitespace-nowrap px-4 py-3 text-sm text-gray-500">{formatMonth(item.month)}</td>
                                                <td className="whitespace-nowrap px-4 py-3 text-sm text-right font-medium text-gray-900">{formatCurrency(item.amount)}</td>
                                            </tr>
                                        ))}
                                    </tbody>
                                    <tfoot className="bg-gray-50">
                                        <tr>
                                            <td colSpan="3" className="px-4 py-3 text-sm font-semibold text-gray-700 text-right">Total</td>
                                            <td className="px-4 py-3 text-sm text-right font-bold text-gray-900">{formatCurrency(payment.total_amount)}</td>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </AuthenticatedLayout>
    );
}
