import Modal from '@/Components/Modal';

export default function FormModal({ show, onClose, title, maxWidth = '2xl', children }) {
    return (
        <Modal show={show} onClose={onClose} maxWidth={maxWidth}>
            <div className="flex items-center justify-between border-b border-gray-100 px-6 py-4">
                <h3 className="text-lg font-semibold text-gray-900">{title}</h3>
                <button
                    type="button"
                    onClick={onClose}
                    className="rounded-lg p-1.5 text-gray-400 hover:bg-gray-100 hover:text-gray-600 transition-colors"
                >
                    <svg className="h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path strokeLinecap="round" strokeLinejoin="round" strokeWidth="2" d="M6 18L18 6M6 6l12 12" />
                    </svg>
                </button>
            </div>
            <div className="px-6 py-5 max-h-[calc(100vh-200px)] overflow-y-auto">
                {children}
            </div>
        </Modal>
    );
}
