#!/bin/bash

# RentDesk Production Deployment Script
# Domain: https://rentdesk.rehanestate.pk

echo "========================================="
echo "   RentDesk Production Setup Script     "
echo "========================================="
echo ""

# Colors
RED='\033[0;31m'
GREEN='\033[0;32m'
YELLOW='\033[1;33m'
NC='\033[0m' # No Color

# Check if we're in the right directory
if [ ! -f "artisan" ]; then
    echo -e "${RED}Error: artisan file not found. Please run this script from the project root.${NC}"
    exit 1
fi

echo -e "${GREEN}Step 1: Installing Composer Dependencies...${NC}"
composer install --no-dev --optimize-autoloader

echo ""
echo -e "${GREEN}Step 2: Generating Application Key...${NC}"
php artisan key:generate

echo ""
echo -e "${GREEN}Step 3: Creating Storage Link...${NC}"
php artisan storage:link

echo ""
echo -e "${GREEN}Step 4: Running Database Migrations...${NC}"
read -p "Are you sure you want to run migrations? (yes/no): " confirm
if [ "$confirm" == "yes" ]; then
    php artisan migrate --force
else
    echo -e "${YELLOW}Skipping migrations...${NC}"
fi

echo ""
echo -e "${GREEN}Step 5: Optimizing Application...${NC}"
php artisan config:cache
php artisan route:cache
php artisan view:cache
composer dump-autoload --optimize
php artisan optimize

echo ""
echo -e "${GREEN}Step 6: Setting Permissions...${NC}"
chmod -R 775 storage
chmod -R 775 bootstrap/cache

echo ""
echo "========================================="
echo -e "${GREEN}✅ Deployment Setup Complete!${NC}"
echo "========================================="
echo ""
echo "Next Steps:"
echo "1. Verify .env configuration"
echo "2. Test the application: https://rentdesk.rehanestate.pk"
echo "3. Create admin user (run: php artisan tinker)"
echo ""
echo "To create admin user:"
echo "  php artisan tinker"
echo "  \$user = new \\App\\Models\\User();"
echo "  \$user->name = 'Admin';"
echo "  \$user->email = 'admin@rehanestate.pk';"
echo "  \$user->password = bcrypt('password');"
echo "  \$user->role = 'admin';"
echo "  \$user->save();"
echo ""
