<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('leases', function (Blueprint $table) {
            $table->enum('commission_type', ['none', 'full_rent', 'half_rent', 'fixed'])->default('none')->after('agreement_notes');
            $table->decimal('commission_amount', 12, 2)->default(0)->after('commission_type');
            $table->string('commission_to')->nullable()->after('commission_amount');
            $table->string('commission_phone')->nullable()->after('commission_to');
            $table->boolean('commission_paid')->default(false)->after('commission_phone');
            $table->date('commission_paid_date')->nullable()->after('commission_paid');
            $table->text('commission_remarks')->nullable()->after('commission_paid_date');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('leases', function (Blueprint $table) {
            $table->dropColumn([
                'commission_type', 'commission_amount', 'commission_to',
                'commission_phone', 'commission_paid', 'commission_paid_date',
                'commission_remarks',
            ]);
        });
    }
};
