<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('leases', function (Blueprint $table) {
            $table->enum('annual_increase_type', ['percentage', 'fixed'])->default('percentage')->after('agreed_rent');
            $table->decimal('annual_increase_value', 10, 2)->default(10)->after('annual_increase_type');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('leases', function (Blueprint $table) {
            $table->dropColumn(['annual_increase_type', 'annual_increase_value']);
        });
    }
};
