<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('owner_trees', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->timestamps();
        });

        Schema::create('owner_tree_members', function (Blueprint $table) {
            $table->id();
            $table->foreignId('owner_tree_id')->constrained()->cascadeOnDelete();
            $table->foreignId('owner_id')->constrained()->cascadeOnDelete();
            $table->timestamps();

            $table->unique(['owner_tree_id', 'owner_id']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('owner_tree_members');
        Schema::dropIfExists('owner_trees');
    }
};
