<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('owner_payments', function (Blueprint $table) {
            $table->id();
            $table->foreignId('owner_id')->constrained('owners')->cascadeOnDelete();
            $table->string('voucher_number')->unique();
            $table->date('payment_date');
            $table->decimal('total_amount', 12, 2);
            $table->enum('payment_method', ['cash', 'bank_transfer'])->default('cash');
            $table->string('proof_file')->nullable();
            $table->boolean('owner_signature_taken')->default(false);
            $table->text('remarks')->nullable();
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('owner_payments');
    }
};
