<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('invoices', function (Blueprint $table) {
            $table->id();
            $table->foreignId('lease_id')->constrained('leases')->cascadeOnDelete();
            $table->string('invoice_number')->unique();
            $table->string('month', 7); // YYYY-MM
            $table->decimal('rent_amount', 12, 2);
            $table->decimal('electricity_amount', 12, 2)->nullable();
            $table->decimal('maintenance_amount', 12, 2)->nullable();
            $table->decimal('other_charges', 12, 2)->default(0);
            $table->string('other_charges_description')->nullable();
            $table->decimal('total_amount', 12, 2);
            $table->date('due_date');
            $table->enum('status', ['pending', 'paid', 'partial', 'overdue'])->default('pending');
            $table->timestamps();

            $table->unique(['lease_id', 'month']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('invoices');
    }
};
