<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('leases', function (Blueprint $table) {
            $table->id();
            $table->foreignId('shop_id')->constrained('shops')->cascadeOnDelete();
            $table->foreignId('tenant_id')->constrained('tenants')->cascadeOnDelete();
            $table->date('start_date');
            $table->integer('grace_days')->default(0);
            $table->date('move_in_date')->nullable();
            $table->date('end_date')->nullable();
            $table->decimal('agreed_rent', 12, 2);
            $table->decimal('initial_rent', 12, 2)->nullable();
            $table->integer('initial_rent_months')->nullable();
            $table->decimal('agreed_security_deposit', 12, 2)->default(0);
            $table->decimal('security_deposit_paid', 12, 2)->default(0);
            $table->decimal('maintenance_fee', 12, 2)->nullable();
            $table->boolean('electricity_enabled')->default(false);
            $table->decimal('electricity_rate_per_unit', 8, 2)->nullable();
            $table->string('agreement_file')->nullable();
            $table->text('agreement_notes')->nullable();
            $table->enum('status', ['active', 'expired', 'terminated'])->default('active');
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('leases');
    }
};
