<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Tenant extends Model
{
    protected $fillable = [
        'name', 'father_name', 'cnic', 'phone',
        'email', 'address', 'photo',
    ];

    public function leases(): HasMany
    {
        return $this->hasMany(Lease::class);
    }

    public function activeLease()
    {
        return $this->hasOne(Lease::class)->where('status', 'active');
    }

    public function getHasActiveLeaseAttribute(): bool
    {
        return $this->leases()->where('status', 'active')->exists();
    }
}
