<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\HasOne;

class Shop extends Model
{
    protected $fillable = [
        'owner_id', 'shop_number', 'description', 'location',
        'area_sqft', 'default_rent', 'status',
    ];

    protected $casts = [
        'area_sqft' => 'decimal:2',
        'default_rent' => 'decimal:2',
    ];

    public function owner(): BelongsTo
    {
        return $this->belongsTo(Owner::class);
    }

    public function leases(): HasMany
    {
        return $this->hasMany(Lease::class);
    }

    public function activeLease(): HasOne
    {
        return $this->hasOne(Lease::class)->where('status', 'active');
    }

    public function getCurrentTenantAttribute()
    {
        $activeLease = $this->activeLease;
        return $activeLease ? $activeLease->tenant : null;
    }
}
