<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;

class OwnerTree extends Model
{
    protected $fillable = ['name'];

    public function owners(): BelongsToMany
    {
        return $this->belongsToMany(Owner::class, 'owner_tree_members')->withTimestamps();
    }
}
