<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class OwnerPaymentItem extends Model
{
    protected $fillable = [
        'owner_payment_id', 'shop_id', 'invoice_id',
        'month', 'amount', 'remarks',
    ];

    protected $casts = [
        'amount' => 'decimal:2',
    ];

    public function ownerPayment(): BelongsTo
    {
        return $this->belongsTo(OwnerPayment::class);
    }

    public function shop(): BelongsTo
    {
        return $this->belongsTo(Shop::class);
    }

    public function invoice(): BelongsTo
    {
        return $this->belongsTo(Invoice::class);
    }
}
