<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Owner extends Model
{
    protected $fillable = [
        'name', 'phone', 'email', 'cnic', 'address',
        'bank_name', 'bank_account_no', 'notes',
    ];

    public function shops(): HasMany
    {
        return $this->hasMany(Shop::class);
    }

    public function ownerPayments(): HasMany
    {
        return $this->hasMany(OwnerPayment::class);
    }

    public function getTotalShopsAttribute(): int
    {
        return $this->shops()->count();
    }

    public function getOccupiedShopsAttribute(): int
    {
        return $this->shops()->where('status', 'occupied')->count();
    }
}
